<?php
/**
 * OTIMIZAÇÃO DE MEMÓRIA E DESIGN DE BOTÕES MELHORADO
 */
ini_set('memory_limit', '512M'); 
error_reporting(0);
ini_set('display_errors', 0); 

include "session.php";
include "config.php";
include "header.php";

function getApiData($url) {
    if (session_status() === PHP_SESSION_NONE) { session_start(); }
    $cacheKey = md5($url);
    if (isset($_SESSION['api_cache'][$cacheKey]) && (time() - ($_SESSION['api_cache_time'][$cacheKey] ?? 0) < 300)) {
        return $_SESSION['api_cache'][$cacheKey];
    }
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) Otimizado');
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_ENCODING, "gzip"); 
    curl_setopt($ch, CURLOPT_TIMEOUT, 10);   
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    if ($httpCode !== 200 || !$response) return [];
    $decodedData = json_decode($response, true);
    if (!is_array($decodedData)) return [];
    $_SESSION['api_cache'][$cacheKey] = $decodedData;
    $_SESSION['api_cache_time'][$cacheKey] = time();
    return $decodedData;
}

$get_dns = $get_dns ?? '';
$username = $username ?? '';
$password = $password ?? '';

// Dados das Séries
$recent_series_url = "$get_dns/player_api.php?username=$username&password=$password&action=get_series&limit=15";
$recent_series = getApiData($recent_series_url);
$categories_url = "$get_dns/player_api.php?username=$username&password=$password&action=get_series_categories";
$channel_api = getApiData($categories_url);
$initial_sections = array_slice($channel_api, 0, 5);
$later_sections = array_slice($channel_api, 5);
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1, viewport-fit=cover" />
    <title>WEB PLAYER</title>
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@400;600;800&display=swap" rel="stylesheet" />
    <style>
        :root { --primary: #e50914; --bg-dark: #0a0a0c; --glass: rgba(255, 255, 255, 0.05); --glass-border: rgba(255, 255, 255, 0.12); }
        body { margin: 0; background: var(--bg-dark); color: #fff; font-family: 'Montserrat', sans-serif; overflow-x: hidden; }

        /* GRIDS */
        .section-header { display: flex; justify-content: space-between; align-items: center; padding: 0 5%; margin-top: 35px; }
        .section-title { font-size: 1.1rem; font-weight: 800; text-transform: uppercase; border-left: 4px solid var(--primary); padding-left: 12px; }

        /* NOVO DESIGN DO BOTÃO VER MAIS */
        .ver-mais-btn {
            background: var(--glass);
            border: 1px solid var(--glass-border);
            color: #fff;
            text-decoration: none;
            font-size: 0.75rem;
            font-weight: 600;
            padding: 6px 16px;
            border-radius: 20px;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            transition: all 0.3s ease;
            backdrop-filter: blur(5px);
        }

        .ver-mais-btn:hover {
            background: var(--primary);
            border-color: var(--primary);
            transform: scale(1.05);
            box-shadow: 0 0 15px rgba(229, 9, 20, 0.4);
        }

        .grid-container { display: flex; gap: 12px; overflow-x: auto; padding: 15px 5%; scrollbar-width: none; }
        .grid-container::-webkit-scrollbar { display: none; }
        
        .grid-item { flex: 0 0 140px; background: var(--glass); border-radius: 12px; overflow: hidden; border: 1px solid var(--glass-border); transition: 0.3s; }
        .grid-item:hover { border-color: var(--primary); transform: translateY(-5px); }
        .grid-item img { width: 100%; height: 200px; object-fit: cover; }
        .grid-item p { font-size: 0.75rem; padding: 8px; text-align: center; margin: 0; white-space: nowrap; overflow: hidden; text-overflow: ellipsis; font-weight: 600; }

        @media (max-width: 768px) {
            .section-title { font-size: 0.9rem; }
            .grid-item { flex: 0 0 125px; }
            .grid-item img { height: 175px; }
        }
    </style>
</head>
<body>

<div class="section-header">
    <h2 class="section-title">Lançamentos Recentes</h2>
    <a class="ver-mais-btn" href="series.php?id=recently_added">Ver todos</a>
</div>
<div class="grid-container">
    <?php foreach ($recent_series as $series): ?>
        <div class="grid-item">
            <a href="seriesvideo?id=<?= $series["series_id"] ?>">
                <img src="<?= !empty($series["cover"]) ? $series["cover"] : "img/sTREAMING (3) (1).png" ?>" alt="Serie" loading="lazy" />
            </a>
            <p><?= htmlspecialchars($series["name"]) ?></p>
        </div>
    <?php endforeach; ?>
</div>

<div id="php-sections">
    <?php foreach ($initial_sections as $value): ?>
        <div class='section-header'>
            <h2 class='section-title'><?= htmlspecialchars($value["category_name"]) ?></h2>
            <a class='ver-mais-btn' href='series.php?id=<?= $value["category_id"] ?>'>Ver Mais</a>
        </div>
        <div class='grid-container' id="grid_<?= $value["category_id"] ?>">
            <?php
            $cid = $value["category_id"];
            $items = getApiData("$get_dns/player_api.php?username=$username&password=$password&action=get_series&category_id=$cid&limit=12");
            foreach ($items as $item):
            ?>
                <div class='grid-item'>
                    <a href='seriesvideo?id=<?= $item["series_id"] ?>'>
                        <img src='<?= !empty($item["cover"]) ? $item["cover"] : "img/sTREAMING (3) (1).png" ?>' alt='Serie' loading='lazy' />
                    </a>
                    <p><?= htmlspecialchars($item["name"]) ?></p>
                </div>
            <?php endforeach; ?>
        </div>
    <?php endforeach; ?>
</div>

<div id="lazy-sections"></div>

<script>
    let laterSections = <?= json_encode($later_sections); ?>;
    let lazyContainer = document.getElementById('lazy-sections');
    let currentIndex = 0;
    let isLoading = false;

    async function fetchMore() {
        if (isLoading || currentIndex >= laterSections.length) return;
        isLoading = true;
        let section = laterSections[currentIndex];
        
        let sectionHTML = `
            <div class="section-header">
                <h2 class="section-title">${section.category_name}</h2>
                <a class="ver-mais-btn" href="series.php?id=${section.category_id}">Ver Mais</a>
            </div>
            <div class="grid-container" id="lazy_grid_${section.category_id}">
                <div style="padding:10px; opacity:0.5;">Carregando...</div>
            </div>`;
        
        lazyContainer.insertAdjacentHTML('beforeend', sectionHTML);

        try {
            const response = await fetch(`<?= $get_dns; ?>/player_api.php?username=<?= $username; ?>&password=<?= $password; ?>&action=get_series&category_id=${section.category_id}&limit=12`);
            const data = await response.json();
            let grid = document.getElementById(`lazy_grid_${section.category_id}`);
            grid.innerHTML = data.map(s => `
                <div class="grid-item">
                    <a href="seriesvideo?id=${s.series_id}">
                        <img src="${s.cover || 'img/sTREAMING (3) (1).png'}" alt="Serie" loading="lazy">
                    </a>
                    <p>${s.name}</p>
                </div>
            `).join('');
        } catch (e) { console.error(e); }
        
        currentIndex++;
        isLoading = false;
    }

    window.addEventListener('scroll', () => {
        if (window.innerHeight + window.scrollY >= document.body.offsetHeight - 500) {
            fetchMore();
        }
    });
</script>
</body>
</html>